# This is a special makefile for cross-building OS-9/68000 C-Kermit 7.0
# on Solaris 7.0 with xcc (Ultra C Version 2.0).  
# ck9ren.c is omitted from this build because rename() is in the library. 
#
# This makefile assumes that the environment variables CDEF and CLIB are
# pointing to the DEFS and LIB directories in an MWOS tree structure for
# your site.(See Ultra C Documentation for this).
#
# Edit the PROGRAM macro to the name you want kermit to have. Note that this
# will be the module name, even if you subsequently rename the file.
#
PROGRAM = kermit
#
#   For network support, enable the following lines:
#
NET_CFLAGS = -dTCPSOCKET
NET_LFLAGS = -l=netdb.l -l=socklib.l
#
#   minimum size:
#
#CPPFLAGS = -dVOID=void -dSIG_V -dDYNAMIC -dZFCDAT -dNOHELP -dNOSCRIPT \
# -dNOSPL -dNOCSETS -dNOMSEND -dNODIAL -dNOICP -dNORANDOM -dNODEBUG -dNOTLOG
#
# minimum size with debug:
#
#CPPFLAGS = -dVOID=void -dSIG_V -dDYNAMIC -dZFCDAT -dNOHELP -dNOSCRIPT \
# -dNOSPL -dNOCSETS -dNOMSEND -dNODIAL -dNOICP -dNORANDOM
#
# maximum size:
#
CPPFLAGS = -dOSK -dVOID=void -dSIG_V -dDYNAMIC -dNOCSETS -dOSKXXC \
	-dZFCDAT -dPARSENSE -dKANJI -dMYCURSES -dNO_DNS_SRV \
	-dCK_APC -dCK_REDIR -dRENAME -dCK_TTYFD -dNOOLDMODEMS -dNORANDOM \
	-dNOMKDIR -dCK_ANSILIBS

###############################################################################
#
#   Target Processsor Type
#
#   Use the appropriate CPU macro depending on your processor.
#   If you choose 68000	or 68010 here and have you may have to
#   omit certain parts of Kermit to fit the data area into <64k.
#   Or modify the compile options to enable a jumptable to be used.
#
#       		Motorola 68000 Family Targets
#          <name>          Target          <name>           Target
#          --------------  ------          --------------   ------
#          68k or 68000    68000           68332            68332
#          010 or 68010    68010           68F333           68f333
#          070 or 68070    68070           68334            68334
#          68301           68301           68340            68340
#          68302           68302           68341            68341
#          68303           68303           68349            68349
#          68306           68306           68360            68360
#          68307           68307           020 or 68020     68020
#          68322           68322           030 or 68030     68030
#          68328           68328           68EC030 or EC030 68EC030
#          CPU32           CPU32           040 or 68040     68040
#          CPU32+          CPU32+          68EC040 or EC040 68EC040
#          68330           68330           68LC040 or LC040 68LC040
#          68331           68331           060 or 68060     68060
#
# CPU and OS can be set for an OS9000 target but this has not been tested.
# Various files which have 68000 assembler code will need to be looked at.
#
CPU 	= 68020		# 68020 should be OK for all >=68020 processors
OS	= OSK
CCFLAGS = -to=$(OS) -tp=$(CPU),ld
LCFLAGS = -to=$(OS) -tp=$(CPU),ld

###############################################################################
#
# Compile Variables:
#
# The -cw option gives verbose compiler warnings.
#
CC 	= xcc
CFLAGS 	= -eas=. -ca $(CCFLAGS) $(CPPFLAGS) $(NET_CFLAGS) -d_OPT_PROTOS ##-cw

###############################################################################
#
# Link variables:
#
# If you don't want to use the csl trap handler, remove the -i option
# from LCFLAGS.
# If you get runtime "stack overflow" errors try increasing the -olM=8K
#
LC 	= $(CC)
LFLAGS 	= $(LCFLAGS) $(NET_LFLAGS) -l=sys_clib.l -l=termlib.l -olM=8k -i

###############################################################################
#
# Dependencies Section:
#
.c.r:
	$(CC) $< $(CFLAGS)

.a.r:
	$(CC) $< $(CFLAGS)

RFILES = ckcmai.r ckclib.r ckucmd.r ckuusr.r ckuus2.r ckuus3.r ckuus4.r \
ckuus5.r ckuus6.r ckuus7.r ckuusx.r ckuusy.r ckcpro.r ckcfns.r ckcfn2.r \
ckcfn3.r ckctel.r ckuxla.r ck9con.r ck9tio.r ck9fio.r ck9asm.r \
ckudia.r ckuscr.r ckusig.r ckcnet.r ckcuni.r

$(PROGRAM): $(RFILES)
	$(LC) $(LFLAGS) -fd=$@ $(RFILES)

ckcmai.r: ckcmai.c ckcsym.h ckcasc.h ckcdeb.h ckcker.h ckcnet.h ckuusr.h \
ckcsig.h

ckclib.r: ckclib.c ckcsym.h ckcasc.h ckcdeb.h

ck9asm.r: ck9asm.a
	$(CC) $(CFLAGS) ck9asm.a

ckcpro.r: ckcpro.c ckcsym.h ckcdeb.h ckcasc.h ckcker.h
	$(CC) $(CFLAGS) ckcpro.c

# -o=0 prevents optimiser warning under xcc v2.0)
ckcfns.r: ckcfns.c ckcsym.h ckcasc.h ckcdeb.h ckcker.h ckcuni.h ckcxla.h \
ckuxla.h
	$(CC) $(CFLAGS) ckcfns.c -o=0

ckcfn2.r: ckcfn2.c ckcsym.h ckcdeb.h ckcasc.h ckcker.h ckcuni.h ckcxla.h \
ckuxla.h

ckcfn3.r: ckcfn3.c ckcsym.h ckcdeb.h ckcasc.h ckcker.h ckcuni.h ckcxla.h \
ckuxla.h

ckuxla.r: ckuxla.c ckcsym.h ckcdeb.h ckcker.h ckucmd.h ckcuni.h ckcxla.h \
ckuxla.h

ckuusr.r: ckuusr.c ckcsym.h ckcdeb.h ckcasc.h ckcker.h ckuusr.h ckucmd.h \
ckcuni.h ckcxla.h ckuxla.h ckcnet.h
	$(CC) $(CFLAGS) ckuusr.c 

ckuus2.r: ckuus2.c ckcsym.h ckcdeb.h ckcnet.h ckcasc.h ckcker.h ckuusr.h \
ckucmd.h ckcuni.h ckcxla.h ckuxla.h
	$(CC) $(CFLAGS) ckuus2.c

ckuus3.r: ckuus3.c ckcsym.h ckcdeb.h ckcasc.h ckcker.h ckcuni.h ckcxla.h \
ckuxla.h ckcnet.h ckuusr.h ckucmd.h
	$(CC) $(CFLAGS) ckuus3.c 

ckuus4.r: ckuus4.c ckcsym.h ckcdeb.h ckcasc.h ckcker.h ckuusr.h ckucmd.h \
ckuver.h ckcnet.h ckcuni.h ckcxla.h ckuxla.h
	$(CC) $(CFLAGS) ckuus4.c

ckuus5.r: ckuus5.c ckcsym.h ckcdeb.h ckcasc.h ckcker.h ckuusr.h ckucmd.h \
ckcnet.h ckcuni.h ckcxla.h ckuxla.h
	$(CC) $(CFLAGS) ckuus5.c

ckuus6.r: ckuus6.c ckcsym.h ckcdeb.h ckcasc.h ckcker.h ckuusr.h ckucmd.h \
ckcuni.h ckcxla.h ckuxla.h ckcnet.h
	$(CC) $(CFLAGS) ckuus6.c

ckuus7.r: ckuus7.c ckcsym.h ckcdeb.h ckcasc.h ckcker.h ckcuni.h ckcxla.h \
ckuxla.h ckcnet.h ckuusr.h ckucmd.h
	$(CC) $(CFLAGS) ckuus7.c -o=0

ckuusx.r: ckuusx.c ckcsym.h ckcdeb.h ckcasc.h ckcker.h ckuusr.h ckucmd.h \
ckcuni.h ckcxla.h ckuxla.h ckcsig.h
	$(CC) $(CFLAGS) ckuusx.c

ckuusy.r: ckuusy.c ckcsym.h ckcdeb.h ckcasc.h ckcker.h ckucmd.h ckcnet.h

ckucmd.r: ckucmd.c ckcsym.h ckcdeb.h ckucmd.h ckcker.h ckcasc.h
	$(CC) $(CFLAGS) $*.c 

ck9fio.r: ck9fio.c ckcsym.h ckcdeb.h ckcker.h ckcasc.h

# Needed only for OS-9 versions that don't have rename() function.
# ck9ren.r: ck9ren.c ckcsym.h ckcdeb.h

ck9tio.r: ck9tio.c ckcsym.h ckcdeb.h ckcnet.h
	$(CC) $(CFLAGS) -dO_GOODDRIVER $*.c 

ck9con.r: ck9con.c ckcsym.h ckcdeb.h ckucmd.h ckcker.h ckcasc.h ckcuni.h \
ckcxla.h ckuxla.h ckcnet.h

ckudia.r: ckudia.c ckcsym.h ckcdeb.h ckcasc.h ckcker.h ckucmd.h ckcnet.h \
ckuusr.h ckcsig.h
	$(CC) $(CFLAGS) $*.c 

ckuscr.r: ckuscr.c ckcsym.h ckcdeb.h ckcasc.h ckcker.h ckuusr.h ckucmd.h \
ckcnet.h ckcsig.h

ckcnet.r: ckcnet.c ckcsym.h ckcdeb.h ckcker.h ckcnet.h ckcsig.h

ckctel.r: ckctel.c ckcsym.h ckcdeb.h ckcker.h ckcnet.h ckctel.h ckclib.h

ckusig.r: ckusig.c ckcasc.h ckcdeb.h ckcker.h ckcnet.h ckuusr.h ckcsig.h

ckcuni.r: ckcuni.c ckcsym.h ckcdeb.h ckucmd.h ckcker.h ckcuni.h ckcxla.h \
ckuxla.h

###############################################################################
#
# Section to make "wart" under Cross Development system
# and then build ckcpro.c from the source file ckcpro.w.
# If you are compiling on a target system, then change the
# gcc line below to your requirements.
#
WART	= ./wart

ckcpro.c: $(WART) ckcpro.w 
	@echo Buidling $@
	$(WART) ckcpro.w ckcpro.c

$(WART): ckwart.c ckcsym.h ckcdeb.h 
	@echo Building Native Version of wart		
	gcc ckwart.c -O2 -o $(WART)
       
###############################################################################
#
# Clean Build
#
clean:	
	-rm $(RFILES) $(WART) ckcpro.c $(PROGRAM)


###############################################################################
#
# Upload OS9 executable to the target system.
# This will have to be modified for your environment.
#
up:	$(PROGRAM)
	mfxup -hx $(PROGRAM) USR/STEVE/CMDS/kermit
	
